clear all
%%% NEED  TO CHANGE SEPARATION (sep), ERROR IN SEPARATION (dsep) AND THE
%%% NUMBER OF POWER STEPS (PS) (IN ErrY and ey2 EQUATIONS) AT EACH TEMPERATURE IF IT CHANGES (CURRENTLY 3)
PS=4;

sep=0.02651;
%dsep=0.03*10^(-3);
dsep=sep*1.5/100;
area=0.000000724;
darea=0.00000000723825;
bond_thickness=3*(319.8*10^(-9));
Si_thickness=sep-bond_thickness;
dLb=bond_thickness*5/100;
%dLSi=0.03*10^(-3);
dLSi=Si_thickness*1.5/100;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% least squares fit (Ref: wolfram mathematica website, http://mathworld.wolfram.com/LeastSquaresFitting.html and Statistics A guide to the use of statistical methods in the physical sciences, R. J. Barlow, Wiley and sons LtD, Chichester, )
% Weighted in x and y. Weights in y are averaged for each temperature
% step.

%Takes in data outputted by labview.
% 1) First breaks the data into power steps and gives average values and standard deviations of
% parameters; P, DT, T. output=[avgT; avgx; stdevx; sterrx; sterrx2; avgy; stdevy; sterry; sterry2]'

% 2) Combines temperature sensor errors with standard errors from data

% 3) Takes the average P and DT associated with each temperature step and calculates the gradient 
% and intercept of the P vs DT graph. 
% The error on the gradient is calculated by generating 10,000 random values (from a gaussian distribution using the mean and errors) for each power. They are fitted to obtain 0,000 gradients. The error on the gradient is the standard deviation of the spread of gradients.
% output2=[T2; grad; err_grad; inter]'

% 4) The error on thermal conductivity is calculated using the errors in the gradient, separation
% and cross sectional area
% output3=[T2; K; DK]'

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

format 'long'
num=xlsread('RawdataD2.xlsx'); % read in excel data sheet 

m=length(num);
X=num(1:m,12); % x data is in  A-B:12 A-B2:31, A2-B:32 
Y=num(1:m,4); % y data is in 4th column, Power 
Z=num(1:m,3); % z is Power step
W=num(1:m,1); % w is temperature
TSerr=num(1:m,22); % TSerr data is in 22nd column, this is the erros associated with the temperature sensors from the data sheet
Verr=num(1:m,23); % Verr data is in 23rd column, this is the error associated with the V value going through the sample
VerrR=num(1:m,24); % VerrR data is in 24th column, this is the error associated with the V value read across the standard resistor
Rerr=num(1:m,25); % Rerr data is in 25th column, this is the erros associated with the R value of the standard resistor 
VS=num(1:m,6); % V going through sample
VR=num(1:m,7); % voltage across standard resistor R
Res=num(1:m,26); % value of standard R

%%%%%%%%%
%This part of the program calls on all the data and separates it in order
%to analize each part. The program runs for example if 64 points of data
%this while/if loop will only run the first 63. The last data set runs outside
%the while/if loop
%%%%%%%%%

max=length(Z);
i=1;
j=1;
k=1;
last_i=0;
last_j=0;
P(1)=X(1);
Q(1)=Y(1);
R(1)=W(1);
S(1)=TSerr(1);
T(1)=Verr(1);
U(1)=VerrR(1);
V(1)=Rerr(1);
M(1)=VS(1);
N(1)=VR(1);
O(1)=Res(1);

sx=0; % sum of x values

sy=0; % sum of y values

sxy=0; % sum of products of x and y

sxsq=0;% sum of squares of x-values

sysq=0;% sum of squares of y-values

while i<max
    i;
    step=Z(i+1)-Z(i);
    if sqrt(step^2) < 0.002 % If we are in the same step, put data into array
        P(i+1)=X(i+1);
        Q(i+1)=Y(i+1);
        R(i+1)=W(i+1);
        S(i+1)=TSerr(i+1);
        T(i+1)=Verr(i+1);
        U(i+1)=VerrR(i+1);
        V(i+1)=Rerr(i+1);
        M(i+1)=VS(i+1);
        N(i+1)=VR(i+1);
        O(i+1)=Res(i+1);

        i=i+1;
    end
    if abs(step) >= 0.002 % If we have changed the step, then calculate the sum and average for the previous step  
        sx(:,j)=sum(P');     
        length_sx(:,j)=i-last_i;
        avgx(:,j)=sx(j)/length_sx(j);
       
        sy(:,j)=sum(Q');
        length_sy(:,j)=i-last_i;
        avgy(:,j)=sy(j)/length_sy(j);
        
       
        k=1;
        while P(k)==0  % need to set all 0 values in P and Q to the average so that ssx and ssy works. (So we don't have extra (0-avgx)^2 in ssx or ssy terms).
        P(k)=avgx(j);
        Q(k)=avgy(j);
        k=k+1;
        end

        ssx(:,j)=sum((P-avgx(j)).^2);
        ssy(:,j)=sum((Q-avgy(j)).^2);
        %%%%
        stdevx(:,j)=sqrt((ssx(j))/(length_sx(j)-1)); % standard deviation of x data
        stdevy(:,j)=sqrt((ssy(j))/(length_sy(j)-1)); % standard deviation of y data
        
        sterrx(:,j)=stdevx(j)/sqrt(length_sx(j)); % standard error on x data
        sterry(:,j)=stdevy(j)/sqrt(length_sy(j)); % standard error on y data
        length_T(:,j)=i-last_i;
        sT(:,j)=sum(R');
        avgT(:,j)=sT(j)/length_sy(j);
        length_TSerr(:,j)=i-last_i;
        avgTSerr(:,j)=sum(S')/length_TSerr(j); 
        length_Verr(:,j)=i-last_i;
        avgVerr(:,j)=sum(T')/length_Verr(j); 
        length_VerrR(:,j)=i-last_i;
        avgVerrR(:,j)=sum(U')/length_VerrR(j);
        length_Rerr(:,j)=i-last_i;
        avgRerr(:,j)=sum(V')/length_Rerr(j); 
        length_V(:,j)=i-last_i;
        avgVS(:,j)=sum(M')/length_V(j);
         length_VR(:,j)=i-last_i;
        avgVR(:,j)=sum(N')/length_VR(j);
         length_R(:,j)=i-last_i;
        avgR(:,j)=sum(O')/length_R(j);
        
        sterrx2(:,j)=sqrt(sterrx(j)^2+TSerr(j)^2); % combined error on Dt from temperature sensor and spread of results
        sterry2(:,j)=sqrt(sterry(j)^2+ 0.0003^2 + (0.01*avgy(j))^2 +((avgy(j)*sqrt((avgVerr(j)/avgVS(j))^2+(avgVerrR(j)/avgVR(j))^2+(avgRerr(j)/avgR(j))^2)))^2); % combined error on P from spread, reading error, 1% for (radiation losses from resistor, power going back up the wires and wires having a resistance)  and V,V,R 
        
         a=avgy(j);
         b=avgVerr(j);
         c=avgVS(j);
        
        
       last_i=i;
       last_j=j;
        j=j+1;
        i=i+1;
        clearvars P Q R S T U V M N O
        P(i)=X(i);
        Q(i)=Y(i);
        R(i)=W(i);
        S(i)=TSerr(i);
        T(i)=Verr(i);
        U(i)=VerrR(i);
        V(i)=Rerr(i);
        M(i)=VS(i);
        N(i)=VR(i);
        O(i)=Res(i);
    end

end
  
  sx(:,j)=sum(P');
  length_sx(:,j)=i-last_i;
  sy(:,j)=sum(Q');
  length_sy(:,j)=i-last_i;
  avgx(:,j)=sx(j)/length_sx(j);
  avgy(:,j)=sy(j)/length_sy(j);
  
  
  k=1;
        while P(k)==0  % need to set all 0 values in P and Q to the average so that ssx and ssy works. (So we don't have extra (0-avgx)^2 in ssx or ssy terms).
        P(k)=avgx(j);
        Q(k)=avgy(j);
        k=k+1;
        end
        
        %%This part is a repitition in terms of the equations to the whi;e/if loop. However, this allows for the final line of data to be processed.
        
        ssx(:,j)=sum((P-avgx(j)).^2);
        ssy(:,j)=sum((Q-avgy(j)).^2);
        %%%%
        stdevx(:,j)=sqrt((ssx(j))/(length_sx(j)-1)); % standard deviation of x data
        stdevy(:,j)=sqrt((ssy(j))/(length_sy(j)-1)); % standard deviation of y data
        
        sterrx(:,j)=stdevx(j)/sqrt(length_sx(j)); % standard error on x data
        sterry(:,j)=stdevy(j)/sqrt(length_sy(j)); % standard error on y data
        length_T(:,j)=i-last_i;
        sT(:,j)=sum(R');
        avgT(:,j)=sT(j)/length_sy(j);
        length_TSerr(:,j)=i-last_i;
        avgTSerr(:,j)=sum(S')/length_TSerr(j); 
        length_Verr(:,j)=i-last_i;
        avgVerr(:,j)=sum(T')/length_Verr(j); 
        length_VerrR(:,j)=i-last_i;
        avgVerrR(:,j)=sum(U')/length_VerrR(j);
        length_Rerr(:,j)=i-last_i;
        avgRerr(:,j)=sum(V')/length_Rerr(j); 
        length_V(:,j)=i-last_i;
        avgVS(:,j)=sum(M')/length_V(j);
         length_VR(:,j)=i-last_i;
        avgVR(:,j)=sum(N')/length_VR(j);
         length_R(:,j)=i-last_i;
        avgR(:,j)=sum(O')/length_R(j);

        
        sterrx2(:,j)=sqrt(sterrx(j)^2+TSerr(j)^2); % combined error on Dt from temperature sensor and spread of results
        sterry2(:,j)=sqrt(sterry(j)^2+ 0.0003^2 + (0.01*avgy(j))^2 +((avgy(j)*sqrt((avgVerr(j)/avgVS(j))^2+(avgVerrR(j)/avgVR(j))^2+(avgRerr(j)/avgR(j))^2)))^2); % combined error on P from spread, reading error, 1% for (radiation losses from resistor, power going back up the wires and wires having a resistance)  and V,V,R 

        
        output=[avgT; avgx; stdevx; sterrx;  sterrx2; avgy; stdevy; sterry; sterry2]' % output the average change in temperature and average power for each step with errors from spread and from temperature sensors 
 dlmwrite('avgT_avgDT_stdDT__stderrDT_P_StdP_stderrP.txt',output) % writes a text file
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

max=length(avgT);
i=1;
j=1;
last_i=0;
last_j=0;
A(1)=avgx(1);
B(1)=avgy(1);
C(1)=avgT(1);
D(1)=stdevx(1);
E(1)=stdevy(1);
F(1)=sterry2(1);
G(1)=sterrx2(1);
temp(1)=A(1);
power(1)=B(1);
count=0;


% 2) Takes the average P and DT associated with each temperature step and calculates the gradient and 
% intercept of the P vs DT graph. The errors on the gradient and intercept are also calculated.  

%%%%%%%%%
%Same as before, this part of the program calls on the data collected previosuly and separates as an avarage of each step, so for the 3 steps you would 
%expect the numer of data points to be 12. Tis while/if loop will only run the first 11 points. The last data set that runs outside
%the while/if loop wil calculate the final line.
%%%%%%%%%

while i<max
   step=avgT(i+1)-avgT(i);
   
    if abs(step) < 0.002 % If the data is in the same step, put data into the same array
        A(i+1)=avgx(i+1);
        B(i+1)=avgy(i+1);
        C(i+1)=avgT(i+1);
        D(i+1)=stdevx(i+1);
        E(i+1)=stdevy(i+1);
        F(i+1)=sterry2(i+1);
        G(i+1)=sterrx2(i+1);
        Dtemp(i+1)=A(i+1);
        power(i+1)=B(i+1);
        i=i+1;
       
    end
    
    if abs(step) > 0.002 % If the step has changed, then calculate the sum and average values for the array containing the values from the previous step
       
       DTs= A(last_i+1:i); % change is temperature for this temperature step
       powers=B(last_i+1:i); % powers for this temperature step
       errINpowers=F(last_i+1:i); % error in power values for this temperature step
       
       %%%%
           %%%%
       % The BigX, smallb are usedin order to calculate the R-squared
       % values from the PvsdT. By including a y-intercept the fit is imporved in your model as y=B0 + B1x . Calculate  B0 by padding x with a column of ones and using the \ operator.
       %http://uk.mathworks.com/help/matlab/data_analysis/linear-regression.html
     %%%%% 
      
 
       
       BigX = [ones(length(DTs'),1) DTs']
     
        smallb = BigX\powers'
        yCalc3 = BigX*smallb
     %   plot(x,yCalc3,'--')
        Rsq(:,j) = 1 - sum((powers' - yCalc3).^2)/sum((powers' - mean(powers')).^2)   %%This final line calculates the R-squared value 
  % such that R2 = 1 – SSresid / SStotal  
       
       
       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       % Adding in the error on gradient by creating 10,000 random points
       % between the error bars and finding 10,000 gradients. Error in
       % gradient is standard devation of all gradients found.
       
N=100;
l=length(powers);
z=1;


while z<=N
 
y1 =normrnd(powers(1),errINpowers(1),[N,1]);

y2 = normrnd(powers(2),errINpowers(2),[N,1]);

y3 = normrnd(powers(3),errINpowers(3),[N,1]);

y4 = normrnd(powers(4),errINpowers(4),[N,1]);

newavgy=[y1 y2 y3 y4];    
    


% Fitting each of the 10,000 random points to give 10,000 gradients
avgx2fits(z)=sum(DTs)/length(DTs);
ssx2fits=sum((DTs-avgx2fits(z)).^2); % ssx2 not weighted
avgy2fits=(y1+y2+y3+y4)/l;

 ssxy2fits(z)=sum((DTs-avgx2fits(z)).*(newavgy(z,:)-avgy2fits(z))); % ssxy2 not weighted
 
gradfits(z,:)=ssxy2fits(z)/ssx2fits; % not weighted and works!
z=z+1;
end

errgrad(:,j)=std(gradfits);
       
       
       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       
  
        sx2(:,j)=sum(A');
        sx22(:,j)=sum(A.^2);
        length_sx2(:,j)=i-last_i;
        avgx2(:,j)=sx2(j)/length_sx2(j);
        avgx22(:,j)=sx22(j)/length_sx2(j);
        sy2(:,j)=sum(B');
        length_sy2(:,j)=i-last_i;
        avgy2(:,j)=sy2(j)/length_sy2(j);
        
    
        ErrY=sum(F')/(PS); % keeping the same error on all y data points. Error is average error on y. There are 4 points in each set.
      
        k=1;
        while F(k)==0
            A(k)=0;
            B(k)=0;
            F(k)=1000000000; % added to weight out the zero error terms from previous steps/iterations
            G(k)=1000000000; % added to weight out the zero error terms from previous steps/iterations
            k=k+1;      
        end
        
        sx3(:,j)=sum((A./(G.^2)));
       
        ex3(:,j)=sum((1./(G.^2)));
        weightx(:,j)=sx3(j)/ex3(j);
        averrx(:,j)=length_sx2(j)/ex3(j);

        sy3(:,j)=sum(B./(ErrY.^2)); % if we use the same value for the error on y (average y error)
        % sy3(:,j)=sum(B./(F.^2)); % if we use each individual error for the y terms
        ey3(:,j)=PS*(1./(ErrY.^2)); % if we use the same value for the error on y (average y error)
        %ey3(:,j)=sum(1./(F.^2)); % if we use each individual error for the y terms
        
        weighty(:,j)=sy3(j)/ey3(j);
        averry(:,j)=length_sy2(j)/ey3(j);
        
        l=1;
        while A(l)==0 % need to set all 0 values in P and Q to the average so that ssx and ssy works. (So we don't have extra (0-avgx)^2 in ssx or ssy terms).
            A(l)=weightx(j); % x weighted
            B(l)=weighty(j); % y weighted
            %A(l)=avgx2(j) % x not weighted
            %B(l)=avgy2(j) % y not weighted
        l=l+1;
        end
        
        %ssx2(:,j)=sum((A-avgx2(j)).^2) % ssx2 not weighted
        %ssy2(:,j)=sum((B-avgy2(j)).^2) % ssy2 not weighted
        %ssxy2(:,j)=sum((A-avgx2(j)).*(B-avgy2(j))) % ssxy2 not weighted
        ssx2(:,j)=sum((A-weightx(j)).^2); % ssx2 weighted
        ssy2(:,j)=sum((B-weighty(j)).^2); % ssy2 weighted
        ssxy2(:,j)=sum((A-weightx(j)).*(B-weighty(j))); % ssxy2 weighted
        
     
          
        %grad(:,j)=ssxy2/ssx2 % not weighted and works!
        %inter(:,j)=avgy2(j)-grad(j)*avgx2(j) % not weighted and works!
   
        grad(:,j)=ssxy2(j)/ssx2(j); % weighted and works   WOLFRAM
        inter(:,j)=weighty(j)-grad(j)*weightx(j); % weighted and works   WOLFRAM
        
        %err_grad(:,j)=(sqrt((ssy2(j)-(ssxy2(j)^2/ssx2(j)))/(length_sx2(j)-2)))/(sqrt(ssx2(j)));% error in gradient wolfram (doesn't take the magnitude of the errors into account)
        %err_inter(:,j)=sqrt(weightx(j))*err_grad(j); % error in intercept

        T2(:,j)=C(i);
        last_i=i;
        j=j+1;
        i=i+1;
        
       
      
        clearvars A B C D E F G 
        A(i)=avgx(i);
        B(i)=avgy(i);
        C(i)=avgT(i);
        D(i)=stdevx(i);
        E(i)=stdevy(i);
        F(i)=sterry2(i);
        G(i)=sterrx2(i);
        Dtemp(i)=A(i);
        power(i)=B(i);
    end
      
end
  
%%%%%%%%%%%%%%%%
%%%%%This part then calculates the last line, so the 12th data point and hence is outside the if loop%%

sx2(:,j)=sum(A');
        sx22(:,j)=sum(A.^2);
        length_sx2(:,j)=i-last_i;
        avgx2(:,j)=sx2(j)/length_sx2(j);
        avgx22(:,j)=sx22(j)/length_sx2(j);
        sy2(:,j)=sum(B');
        length_sy2(:,j)=i-last_i;
        avgy2(:,j)=sy2(j)/length_sy2(j);
        
      %  sterry3(:,j)=sum(F')/length_sy2(j);
         
      ErrY=sum(F')/PS; % keeping the same error on all y data points. Error is average error on y. PS is the number of data points in each set.
        
      k=1;
        while F(k)==0
            A(k)=0;
            B(k)=0;
            F(k)=1000000000; % added to weight out the zero error terms from previous steps/iterations
            G(k)=1000000000; % added to weight out the zero error terms from previous steps/iterations
            k=k+1;      
        end
        %
        sx3(:,j)=sum((A./(G.^2)));
        
        ex3(:,j)=sum((1./(G.^2)));
        weightx(:,j)=sx3(j)/ex3(j);
        averrx(:,j)=length_sx2(j)/ex3(j);
      
      sy3(:,j)=sum(B./(ErrY.^2)); % if we use the same error on each y (average the error)
      ey3(:,j)=PS*(1./(ErrY.^2)); % if we use the same error on each y (average the error)
%        sy3(:,j)=sum(B./(F.^2)); % if we use each individual error for y
%       ey3(:,j)=sum(1./(F.^2)); % if we use each individual error for y
      
      weighty(:,j)=sy3(j)/ey3(j);
        averry(:,j)=length_sy2(j)/ey3(j);
        
        l=1;
        while A(l)==0 % need to set all 0 values in P and Q to the average so that ssx and ssy works. (So we don't have extra (0-avgx)^2 in ssx or ssy terms).
            A(l)=weightx(j); % x weighted
            B(l)=weighty(j); % y weighted
            %A(l)=avgx2(j) % x not weighted
            %B(l)=avgy2(j) % y not weighted
        l=l+1;
        end
        
        %ssx2(:,j)=sum((A-avgx2(j)).^2) % ssx2 not weighted
        %ssy2(:,j)=sum((B-avgy2(j)).^2) % ssy2 not weighted
        %ssxy2(:,j)=sum((A-avgx2(j)).*(B-avgy2(j))) % ssxy2 not weighted
        ssx2(:,j)=sum((A-weightx(j)).^2); % ssx2 weighted
        ssy2(:,j)=sum((B-weighty(j)).^2); % ssy2 weighted
        ssxy2(:,j)=sum((A-weightx(j)).*(B-weighty(j))); % ssxy2 weighted
        
      T2(:,j)=C(i);
      
    DTs=A(last_i+1:i);
powers=B(last_i+1:i);
errINpowers=F(last_i+1:i);
    BigX = [ones(length(DTs'),1) DTs']
     
        smallb = BigX\powers'
        yCalc3 = BigX*smallb
     %   plot(x,yCalc3,'--')
           %%Same asbefore the values for BigX,smallb and ycalc3 are addedhere
      %%in order ro obtain the final line of data
      
      
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       % Adding in the error on gradient by creating 10,000 random points
       % between the error bars and finding 10,000 gradients. Error in
       % gradient is standard devation of all gradients found.
       
N=10000;
l=length(powers);
z=1;


while z<=N
 
y1 =normrnd(powers(1),errINpowers(1),[N,1])  ;

y2 = normrnd(powers(2),errINpowers(2),[N,1]);

y3 = normrnd(powers(3),errINpowers(3),[N,1]);

y4 = normrnd(powers(4),errINpowers(4),[N,1]);

newavgy=[y1 y2 y3 y4];    
    

% Fitting each of the 10,000 random points to give 10,000 gradients
avgx2fits(z)=sum(DTs)/length(DTs);
ssx2fits=sum((DTs-avgx2fits(z)).^2); % ssx2fits not weighted
avgy2fits=(y1+y2+y3+y4)/l;

 ssxy2fits(z)=sum((DTs-avgx2fits(z)).*(newavgy(z,:)-avgy2fits(z))); % ssxy2fits not weighted
 
gradfits(z,:)=ssxy2fits(z)/ssx2fits; % not weighted
z=z+1;

end

errgrad(:,j)=std(gradfits);
  Rsq(:,j) = 1 - sum((powers' - yCalc3).^2)/sum((powers' - mean(powers')).^2)    %%This final line calculates the R-squared value 
  % such that R2 = 1 – SSresid / SStotal  
       %%%%
     
       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


        %grad(:,j)=ssxy2/ssx2 % not weighted and works!
        %inter(:,j)=avgy2(j)-grad(j)*avgx2(j) % not weighted and works!
   
        grad(:,j)=ssxy2(j)/ssx2(j); % weighted and works   WOLFRAM
        inter(:,j)=weighty(j)-grad(j)*weightx(j); % weighted and works   WOLFRAM
            
%%%%%%%%%%%%%%%%%%
Rsq;
        
   output2=[T2; grad; errgrad; inter; Rsq]' % output the gradient and intercept for the graph of P vs DT associated with each step and calculates the error on the gradient 
   dlmwrite('avgT_grad_errgrad_inter.txt',output2) % writes a text file
 
 
 
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
 
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
 % Calculating the error in TC from the errors in the gradient, separation
 % and cross sectional area 
 

max=length(T2);

for i=1:max 
    
K(:,i)=grad(i)*sep/area; % calculates TC
DK(:,i)= K(i)*((errgrad(i)/grad(i))^2+(dsep/sep)^2+(darea/area)^2)^(1/2); % Calculates error on TC

end

output3=[T2; K; DK;Rsq]' % outputs temp, thermal conductivity, and error on thermal conductivity 
 dlmwrite('Temp_TC_DTC_R2.txt',output3) % writes a text file
 
 
%format 'long'
%num=xlsread('Ksi.xlsx'); % read in excel data sheet 

%m=length(num);
%Ksi=num(1:m,2); % x data is in 2nd column
%Kbond(:,i)=bond_thickness/((sep/K(i))-(Si_thickness/Ksi(i)'));
%Kbond=bond_thickness./((sep./K)-(Si_thickness./Ksi'));
%sKsi=num(1:m,3); %  data is in 3rd column, 



%DCA=((sep./K).^2).* ((dsep/sep).^(2)+ ( DK./K).^(2))   ;
%DCB= ((Si_thickness./Ksi).^2).*  ((dLSi/Si_thickness).^(2) + (sKsi./Ksi).^(2));
%DCC= ( (sep./K)' - ( Si_thickness./Ksi ) ).^(2);
%DCD= (DCB' + DCA);
%DC= DCD ./ DCC';
  %DC=((sep./K).^2*((dsep/sep)^2+(DK/K)^.2))+((Si_thickness/Ksi).^2)*((((dLSi/Si_thickness)^2))+((sKsi/Ksi)^2));
%DKbond_Kbond= (((dLb./bond_thickness).^2) + DC).^(1/2);
%DKbond=DKbond_Kbond.*Kbond;
%((((dLb./bond_thickness).^2)+(DC^2))^(-1/2)).*Kbond;
%*(((dsep/sep)((.^)2)+((DK/K)^.2)))+(((Si_thickness./Ksi)^.2).*(((dLSi./Si_thickness).^2)+((sKsi./Ksi).^2)));

%output4=[T2;Ksi';sKsi']' % outputs temp, thermal conductivity, and error on thermal conductivity 
%dlmwrite('Ksi.txt',output4) % writes a text file
 %plot(T2, Kbond,'*')
 
 %output5=[T2;Ksi';sKsi';K;DK;Kbond;DKbond]'
  %dlmwrite('All_TCs.txt',output5) 
  
  
  
 
 
 
